/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.whatif;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.whatif.WhatIfBound;
import javax.annotation.Nonnull;

public class WhatIfEntity {
    private final EntityType type;
    private final String id;

    public WhatIfEntity(@Nonnull EntityType type, @Nonnull String id) {
        this.type = Preconditions.checkNotNull(type);
        this.id = Preconditions.checkNotNull(id);
    }

    @Nonnull
    public EntityType getType() {
        return this.type;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WhatIfEntity)) {
            return false;
        }
        WhatIfEntity that = (WhatIfEntity)o;
        return this.type == that.type && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("type", (Object)this.type).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EntityType {
        MATERIAL{

            @Override
            public WhatIfBound.BoundType getBoundType() {
                return WhatIfBound.BoundType.LOWER;
            }
        }
        ,
        WORKCENTER{

            @Override
            public WhatIfBound.BoundType getBoundType() {
                return WhatIfBound.BoundType.UPPER;
            }
        };


        public abstract WhatIfBound.BoundType getBoundType();
    }
}

